<?php

/**
 * Add notification when there is no extension added or only the default extensions exist
 * Recurrence: 20 Days
 *
 * @since 7.12.3
 */
final class MonsterInsights_Notification_To_Add_More_File_Extensions extends MonsterInsights_Notification_Event {

	public $notification_id = 'monsterinsights_notification_to_add_more_file_extensions';
	public $notification_interval = 20; // in days
	public $notification_type = array( 'basic', 'lite', 'master', 'plus', 'pro' );
	public $notification_category = 'insight';
	public $notification_priority = 2;

	/**
	 * Build Notification
	 *
	 * @return array $notification notification is ready to add
	 *
	 * @since 7.12.3
	 */
	public function prepare_notification_data( $notification ) {
		$download_extensions = monsterinsights_get_option( 'extensions_of_files', '' );

		if ( empty( $download_extensions ) || "doc,pdf,ppt,zip,xls,docx,pptx,xlsx" === $download_extensions ) {

			$settings_url          = is_network_admin() ? $this->get_view_url( 'monsterinsights-settings-block-file-downloads', 'monsterinsights_network', 'engagement' ) : $this->get_view_url( 'monsterinsights-settings-block-file-downloads', 'monsterinsights_settings', 'engagement' );
			$publishers_report_url = $this->get_view_url( 'monsterinsights-report-download-links', 'monsterinsights_reports', 'publishers' );
			$notification['title'] = __( 'Track Your Website Downloads', 'google-analytics-for-wordpress' );

			$notification['content'] = sprintf(
				/* translators: Placeholders add links to settings pages. */
				__( 'By default, MonsterInsights automatically tracks downloads of the following file extensions: doc, pdf, ppt, zip, xls, docx, pptx, and xlsx. You can easily add or remove extensions from that list in the %1$sEngagement settings%2$s of MonsterInsights.<br><br> You can view your Top Downloads report directly in the MonsterInsights %3$sPublishers report%4$s.', 'google-analytics-for-wordpress' ),
				'<a href="' . $settings_url . '">',
				'</a>',
				'<a href="' . $publishers_report_url . '">',
				'</a>'
			);
			$notification['btns']    = array(
				"add_more_file_extensions" => array(
					'url'  => $settings_url,
					'text' => __( 'Add File Extensions', 'google-analytics-for-wordpress' )
				),
			);

			return $notification;
		}

		return false;
	}

}

// initialize the class
new MonsterInsights_Notification_To_Add_More_File_Extensions();
